<?php
/**
 * GdImage example for displaying additional text under the QR Code
 *
 * @link https://github.com/chillerlan/php-qrcode/issues/35
 *
 * @created      22.06.2019
 * @author       Smiley <smiley@chillerlan.net>
 * @copyright    2019 Smiley
 * @license      MIT
 *
 * @noinspection PhpIllegalPsrClassPathInspection, PhpComposerExtensionStubsInspection
 */
declare(strict_types=1);

use chillerlan\QRCode\{QRCode, QROptions};
use chillerlan\QRCode\Output\QRGdImagePNG;
use MiladRahimi\PhpCrypt\Symmetric;

require_once __DIR__.'/../vendor/autoload.php';

session_start();
//error_reporting(0);
include '../../includes/config.php';
if (false) {
    header("Location: index.php");
} else {

$stid = intval($_GET['stid']);}
/*
 * Class definition
 */

class QRImageWithText extends QRGdImagePNG{

	public function dump(string|null $file = null, string|null $text = null):string{
		// set returnResource to true to skip further processing for now
		$this->options->returnResource = true;

		// there's no need to save the result of dump() into $this->image here
		parent::dump($file);

		// render text output if a string is given
		if($text !== null){
			$this->addText($text);
		}

		$imageData = $this->dumpImage();

		$this->saveToFile($imageData, $file);

		if($this->options->outputBase64){
			$imageData = $this->toBase64DataURI($imageData);
		}

		return $imageData;
	}

	protected function addText(string $text):void{
		// save the qrcode image
		$qrcode = $this->image;

		// options things
		$textSize  = 3; // see imagefontheight() and imagefontwidth()
		$textBG    = [200, 200, 200];
		$textColor = [50, 50, 50];

		$bgWidth  = $this->length;
		$bgHeight = ($bgWidth + 20); // 20px extra space

		// create a new image with additional space
		$this->image = imagecreatetruecolor($bgWidth, $bgHeight);
		$background  = imagecolorallocate($this->image, ...$textBG);

		// allow transparency
		if($this->options->imageTransparent){
			imagecolortransparent($this->image, $background);
		}

		// fill the background
		imagefilledrectangle($this->image, 0, 0, $bgWidth, $bgHeight, $background);

		// copy over the qrcode
		imagecopymerge($this->image, $qrcode, 0, 0, 0, 0, $this->length, $this->length, 100);
		imagedestroy($qrcode);

		$fontColor = imagecolorallocate($this->image, ...$textColor);
		$w         = imagefontwidth($textSize);
		$x         = round(($bgWidth - strlen($text) * $w) / 2);

		// loop through the string and draw the letters
		foreach(str_split($text) as $i => $chr){
			imagechar($this->image, $textSize, (int)($i * $w + $x), $this->length, $chr, $fontColor);
		}
	}

}


/*
 * Runtime
 */

$options = new QROptions;

$options->version      = 7;
$options->scale        = 3;
$options->outputBase64 = false;


//$qrcode = new QRCode($options);


// default output is a base64 encoded data URI
?>
<style>
svg{
	height:200px!important;margin-left:50px!important
}
input[type=text]{border:none!important;background:#fff!important}
</style>



<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SMS Admin| Edit Student < </title> <link rel="stylesheet" href="../../css/bootstrap.min.css" media="screen">
            <link rel="stylesheet" href="../../css/font-awesome.min.css" media="screen">
            <link rel="stylesheet" href="../../css/animate-css/animate.min.css" media="screen">
            <link rel="stylesheet" href="../../css/lobipanel/lobipanel.min.css" media="screen">
            <link rel="stylesheet" href="../../css/prism/prism.css" media="screen">
            <link rel="stylesheet" href="../../css/select2/select2.min.css">
            <link rel="stylesheet" href="../../css/main.css" media="screen">
            <script src="../../js/modernizr/modernizr.min.js"></script>
</head>

<body class="top-navbar-fixed">
 <div class="main-wrapper">

        <!-- ========== TOP NAVBAR ========== -->
        <?php include '../../includes/topbar.php';?>
        <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
        <div class="content-wrapper">
            <div class="content-container">

                <!-- ========== LEFT SIDEBAR ========== -->
                <?php include '../../includes/leftbar.php';?>
                <!-- /.left-sidebar -->

                <div class="main-page">

                    <div class="container-fluid">
                        <div class="row page-title-div">
                            <div class="col-md-6">
                                <h2 class="title">Student Admission</h2>

                            </div>

                            <!-- /.col-md-6 text-right -->
                        </div>
                        <!-- /.row -->
                        <div class="row breadcrumb-div">
                            <div class="col-md-6">
                                <ul class="breadcrumb">
                                    <li><a href="dashboard.php"><i class="fa fa-home"></i> Home</a></li>

                                    <li class="active">Student Admission</li>
                                </ul>
                            </div>

                        </div>
                        <!-- /.row -->
                    </div>
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel">
                                    <div class="panel-heading">
                                        <div class="panel-title">
                                            <h5>Access Result Student info</h5>
                                        </div>
                                    </div>
                                    <div class="panel-body">
                                        
                                        <form class="form-horizontal" method="post">
                                            <?php

$sql = "SELECT tblstudents.StudentName,tblstudents.RollId,tblstudents.RegDate,tblstudents.StudentId,tblstudents.Status,tblstudents.StudentEmail,tblstudents.Gender,tblstudents.DOB,tblclasses.ClassName,tblclasses.Section from tblstudents join tblclasses on tblclasses.id=tblstudents.ClassId where tblstudents.StudentId=:stid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':stid', $stid, PDO::PARAM_STR);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_OBJ);
    $cnt = 1;
    if ($query->rowCount() > 0) {
        foreach ($results as $result) {?>


                                            <div class="form-group">
                                                <label for="default" class="col-sm-2 control-label">Full Name</label>
                                                <div class="col-sm-10">
                                                    <input type="text" disabled name="fullanme" class="form-control"
                                                        id="fullanme"
                                                        value="<?php echo htmlentities($result->StudentName) ?>"
                                                        required="required" autocomplete="off">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label for="default"  class="col-sm-2 control-label">Student Id</label>
                                                <div class="col-sm-10">
                                                    <input type="text" disabled  name="rollid" class="form-control" id="rollid"
                                                        value="<?php echo htmlentities($result->RollId) ?>" maxlength="5"
                                                        required="required" autocomplete="off">
                                                </div>
												<?php 
												
												$symmetric = new Symmetric();
$encryptedData = $symmetric->encrypt(htmlentities($stid));
$data='http://172.23.237.172/student/stresult?stid='.$stid;

// invoke the custom output interface manually
//$qrOutputInterface = new QRImageWithText($options, $qrcode->getQRMatrix());

// dump the output, with additional text
// the text could also be supplied via the options, see the svgWithLogo example
//$out = $qrOutputInterface->dump(null, 'example text');

$qrcode = (new QRCode($options))->render($data, __DIR__.'/qrOutput/qrCode.svg');
												?>
                                            </div>




                                            <div class="form-group">
                                                <label for="default"  class="col-sm-2 control-label">Gender</label>
                                                <div class="col-sm-10">
                                                    <?php $gndr = $result->Gender;
            if ($gndr == "Male") {
                ?>
                                                    <input type="radio" disabled  name="gender" value="Male" required="required"
                                                        checked>Male <input type="radio" name="gender" value="Female"
                                                        required="required">Female <input type="radio" name="gender"
                                                        value="Other" required="required">Other
                                                    <?php }?>
                                                    <?php
if ($gndr == "Female") {
                ?>
                                                    <input type="radio" name="gender" value="Male"
                                                        required="required">Male <input type="radio" name="gender"
                                                        value="Female" required="required" checked>Female <input
                                                        type="radio" name="gender" value="Other"
                                                        required="required">Other
                                                    <?php }?>
                                                    <?php
if ($gndr == "Other") {
                ?>
                                                    <input type="radio" name="gender" value="Male"
                                                        required="required">Male <input type="radio" name="gender"
                                                        value="Female" required="required">Female <input type="radio"
                                                        name="gender" value="Other" required="required" checked>Other
                                                    <?php }?>


                                                </div>
                                            </div>



                                            <div class="form-group">
                                                <label for="default" class="col-sm-2 control-label">Class</label>
                                                <div class="col-sm-10">
                                                    <input type="text" name="classname" class="form-control"
                                                        id="classname"
                                                        value="<?php echo htmlentities($result->ClassName) ?>(<?php echo htmlentities($result->Section) ?>)"
                                                        readonly>
                                                </div>
                                            </div>
                                         
                                           
                                            

                                            <?php }}?>
 <?php


printf($qrcode);
?>

                                            <div class="form-group">
                                                <div class="col-sm-offset-2 col-sm-10">
                                                    <button type="submit" name="submit" style="display:inline-block;float:right;align:right"
                                                        class="btn btn-primary">download</button>
                                                </div>
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>
                            <!-- /.col-md-12 -->
                        </div>
                    </div>
                </div>
                <!-- /.content-container -->
            </div>
            <!-- /.content-wrapper -->
        </div>

 <script src="../../js/jquery/jquery-2.2.4.min.js"></script>
        <script src="../../js/bootstrap/bootstrap.min.js"></script>
        <script src="../../js/pace/pace.min.js"></script>
        <script src="../../js/lobipanel/lobipanel.min.js"></script>
        <script src="../../js/iscroll/iscroll.js"></script>
        <script src="../../js/prism/prism.js"></script>
        <script src="../../js/select2/select2.min.js"></script>
        <script src="../../js/main.js"></script>
        <script>
            $(function ($) {
                $(".js-states").select2();
                $(".js-states-limit").select2({
                    maximumSelectionLength: 2
                });
                $(".js-states-hide").select2({
                    minimumResultsForSearch: Infinity
                });
            });
        </script>


<?php


//header('Content-type: image/png');

//echo $out;

exit;
